/*
 NYTimes API Classes
 February, 2009
 blprnt@blprnt.com
 NOTE: Make sure you enter your NYTimes Article Search API on the TimesArticleSearch tab.
 Created by Joshua Dickinson, updated by Yoon Chung Han
 */
import processing.opengl.*;
import org.json.*;
import java.util.ArrayList;

PFont font1 = createFont("Helvetica", 15); 
PFont font2 = createFont("Helvetica", 30);
int[][] transactionsPerMonth = new int[6][12];
int[][] articlesPerMonth = new int[6][12];
int[][] frontPagePerMonth = new int[6][12];
String[][] articleTitles = new String[6][12];


boolean showGrid = false;
boolean leftMouseClicked = false;
boolean rightMouseClicked = false;
boolean addColor = false;
int displayMode = 1;
int padding = 10;
float horizontalGridDivisions = 8;
float verticalGridDivisions = 12;
float horizontalSquareSize;
float verticalSquareSize;

void setup() {
  size(900, 640); //size of the sketch window
  horizontalSquareSize = width/horizontalGridDivisions;
  verticalSquareSize = height/verticalGridDivisions;
  colorMode(HSB, 360, 100, 100,100);  
  smooth();
  
  //import the data from our text file 
  String savedData[] = loadStrings("vampire.txt");
  println("QUERY: " + savedData[0]);
  for (int i=1; i < savedData.length; i++) {
    String temp[] = split(savedData[i], ",");
    transactionsPerMonth[Integer.parseInt(temp[0])-2003][Integer.parseInt(temp[1])-1] = Integer.parseInt(temp[2]);
  } 
  
  //ny times api stuff
  for(int i = 0; i<5; i++){
    for(int j = 0; j<12; j++){
      TimesArticleSearch s = new TimesArticleSearch();
      s.addQueries("vampire");
      s.addFacets("page_facet");
      s.addFacetQuery("publication_year", "" + (2003+i));

      //we have to turn the month into a string like "07" which is kind of annoying. 
      String m = (j + 1 < 10) ? ("0" + str(int(j) + 1)):str(j + 1);
      s.addFacetQuery("publication_month", m);
      TimesArticleSearchResult r = s.doSearch();
      TimesFacetObject[] pageFacets = r.getFacetList("page_facet");
      
      println ("There were " + r.total + " articles.");
      println ("There were " + pageFacets[0].count + " articles on the front page");
      println ("The first article was titled: " + r.results[0].title);
      articlesPerMonth[i][j] = r.total;
      articleTitles[i][j] = r.results[0].title;
      frontPagePerMonth[i][j] = pageFacets[0].count;
    }
  }

}

void draw(){
  background(0);
  if(showGrid){drawGrid();}
  
  float circleDivision = (PI*2.0)/60.0;
  float horizontalDivision = (width-(padding*2))/60.0;//(horizontalSquareSize*7.0+padding)/60.0;
  
  for(int i = 0;i<5;i++){
    fill(0,100,50,100);
    strokeWeight(1.0);
    for(int j = 0;j<12;j++){
     
     //if displayMode is 2 draw radial diagram 
     if(displayMode == 2){
       pushMatrix();
       translate(width/2,height/2);
       rotate(circleDivision*(i*12+j)+PI);
       stroke(0,100,100, 40+(60.0/width)*(width-mouseX));
       line(0,0,0,transactionsPerMonth[i][j]*0.2);
       rotate(0.02);
       stroke(0,0,100,40+(60.0/width)*mouseX);
       line(0,0,0,articlesPerMonth[i][j]*5.0);
       if(j==0){
         translate(0,100);
         rotate(-1*PI);
         textFont(font1);
         fill(0,100,60);
         textAlign(CENTER,CENTER);
         text(2003+i,0,0);
       } 
       popMatrix();
     }
     
     //id displayMode is 1, draw bar diagram
     if(displayMode == 1){
       //SPL transactions line
       strokeWeight(1.0);
       stroke(0,100,100, 40+(60.0/width)*(width-mouseX));
       line(padding+horizontalDivision*((12*i)+j), verticalSquareSize-padding, padding+horizontalDivision*((12*i)+j), transactionsPerMonth[i][j]*0.5+verticalSquareSize-padding);
       
       //NYtimes line
       stroke(0,0,100,40+(60.0/width)*mouseX);
       fill(0,0,100,40+(60.0/width)*mouseX);
       line(padding+horizontalDivision*((12*i)+j)+2, verticalSquareSize-padding, padding+horizontalDivision*((12*i)+j)+2, articlesPerMonth[i][j]*15.0+verticalSquareSize-padding);
       //Circle for amount of front page articles
       ellipse(padding+horizontalDivision*((12*i)+j)+2, articlesPerMonth[i][j]*15.0+verticalSquareSize-padding, 4*sqrt(frontPagePerMonth[i][j]),4*sqrt(frontPagePerMonth[i][j]));
       
       //draw the year labels every 12 months
       if(j==0){
         textFont(font1);
         fill(0,100,60);
         textAlign(LEFT,TOP);
         text(2003+i,padding+horizontalDivision*((12*i)+j),padding);
       }
       
       //rollover for new york times article titles
       if(abs(mouseX-(padding+horizontalDivision*((12*i)+j)))<7){
         textAlign(LEFT,BOTTOM);
         fill(0,0,100,60);
         text(articleTitles[i][j],padding, height-verticalSquareSize*2-padding);
       }
     
      }
    }
  }
  
  //draw your title and labels
  textFont(font2);
  fill(0,100,50);
  textAlign(RIGHT,BOTTOM);
  text("Titles Including \"Vampire\"", width-padding, height-padding);
  
  textFont(font2);
  fill(0,100,60, 40+(60.0/width)*(width-mouseX));//70+(30.0/width)*(width-mouseX)
  textAlign(LEFT,BOTTOM);
  text("Seattle Public Library", padding, height-padding);
  
  fill(0,0,100,40+(60.0/width)*mouseX);//
  textAlign(LEFT,BOTTOM);
  text("New York Times", padding, height-verticalSquareSize-padding);
  
}



//Grid nonsense
void drawGrid(){
  //draw horizontal grid
  stroke(0,0,70);
  strokeWeight(0.5);
  for(int i = 0;i<=horizontalGridDivisions;i++){
    line(i*horizontalSquareSize-padding,0,i*horizontalSquareSize-padding, height);
    line(i*horizontalSquareSize+padding,0,i*horizontalSquareSize+padding, height);
  }
  //draw vertical grid
  stroke(0,0,70);
  strokeWeight(0.5);
  for(int i = 0;i<=verticalGridDivisions;i++){
    line(0,i*verticalSquareSize-padding,width, i*verticalSquareSize-padding);
    line(0,i*verticalSquareSize+padding,width, i*verticalSquareSize+padding);
  }
}

//controls
void keyPressed(){
 //press spacebar to toggle the grid on and off  
 if(key == ' '){
  showGrid = !showGrid;
 }
 if(key == '1'){
   displayMode = 1;
 } 
 if(key == '2'){
   displayMode = 2;
 }
}
