// get NYTimes Data
int [][]getNYTimesData(String[] queryWords, int nYearStart, int nYearEnd, String strFilename)
{
  assert(nYearStart > 0);
  assert(nYearEnd > 0);
  assert(nYearStart <= nYearEnd);
  assert(strFilename.length() > 0);

  int [][] pFreq = new int[queryWords.length][(nYearEnd-nYearStart+1)*12];

  try {
    println("reading "+strFilename+"...");
    String savedData[] = loadStrings(strFilename);

    for (int i=0; i < savedData.length; i++) {
      String temp[] = split(savedData[i], ",");
      pFreq[0][i] = Integer.parseInt(temp[0]);
      pFreq[1][i] = Integer.parseInt(temp[1]);
    }
  } 
  catch (Exception E) {
    String savedData[] = new String[(nYearEnd-nYearStart+1)*12];

    for (int i=0; i < nYearEnd-nYearStart+1; i++) {
      for ( int j=0; j < 12; j++ ) {

        int y = nYearStart+i;
        int m = j+1;
        int idx = i*12+j;

        String s = String.format("%d%02d01", y, m);
        String e = String.format("%d%02d%02d", y, m, getDayByYearAndMonth(y, m));

        savedData[idx] = "";
        for ( int k=0; k<queryWords.length; k++ ) {
          pFreq[k][idx] = getArticleKeywordCount( queryWords[k], s, e);

          savedData[idx] += String.format("%d", pFreq[k][idx]);
          if ( k+1!=queryWords.length ) savedData[idx] += ",";
        }
      }
    }

    saveStrings(strFilename, savedData);
  }

  return pFreq;
}

// get SPL data
int [][]getSPLData(String[] pFilenames, int nYearStart, int nYearEnd)
{
  assert(nYearStart > 0);
  assert(nYearEnd > 0);
  assert(nYearStart <= nYearEnd);

  int [][] pFreq = new int[pFilenames.length][(nYearEnd-nYearStart+1)*12];

  // read text files of SPL
  try {
    // get data
    for (int i=0; i<pFilenames.length; i++ ) {

      println("reading "+pFilenames[i]+"...");
      String [] textData = loadStrings(pFilenames[i]);

      for ( int j=1; j<textData.length; j++ ) {
        String textSplitted[] = split(textData[j], ",");

        int y = (int)Integer.parseInt(textSplitted[0]);
        int m = (int)Integer.parseInt(textSplitted[1]);
        int val = (int)Integer.parseInt(textSplitted[2]);

        pFreq[i][(y-2005)*12+m-1] = val;
      }
    }
  } 
  catch (Exception E) {
    println("Error in reading SPL data.");
    ;
  }

  return pFreq;
}

