void draw()
{
  // for animation
  float fTimeDiff = (float)(millis() - gnTimeStart)/1000.0f;

  // select data by current mode
  int [][]pData = null;
  int nDataMax = 0;
  String strTitle = "";
  
  //south(blue)
  float RGB_R1 = 0.0f;
  float  RGB_G1 = 0.3f;
  float  RGB_B1 = 1.0f;
  
  //north(red)
  float  RGB_R2 = 1.0f;
  float  RGB_G2 = 0.2f;
  float RGB_B2 = 0.0f;



  // draw start
  
  pushMatrix();
  pushStyle();

    

  colorMode(RGB, 1.0f);
  background(0.0f);
  fill(.9f);
  textFont(myFont3);
  textAlign(LEFT, CENTER);
  text(strTitle, 50, 40);

  // # of bars and bar sizes
  int   nItems = (gnYearEnd-gnYearStart+1)*12;
  float fWidth = (float)(width-gfHMargin*2)/(float)nItems;
  float fHeight = (float)(height-gfVMargin*2)/2.0f;
  float fAnimationRatio = fTimeDiff / gfAnimationSpeed;
  if ( fAnimationRatio > 1.0f ) fAnimationRatio = 1.0f;
  
  // background gradient images
  float fBgBoxWidth = (width-gfHMargin*2)/float(gnYearEnd-gnYearStart+1);
  float fBgBoxHeight = (height-gfVMargin*2)/2.0f;

  noStroke();  
  for (int y=0; y<gnYearEnd-gnYearStart+1; y++ )  {
    float fBgBoxOffsetX = gfHMargin + fBgBoxWidth * y;
    float fBgBoxOffsetY = gfVMargin;
    float fBgBoxSliceWidth = fBgBoxWidth / float(gnBgBoxGradientLevel);
    
    for (int x=0; x<gnBgBoxGradientLevel; x++ )  {
      
      fill( 1.0f, 1.0f, 1.0f, .09f * ( 1.0f - 1.0f/float(gnBgBoxGradientLevel)*float(x) ) * fAnimationRatio );
      rect( fBgBoxOffsetX + fBgBoxSliceWidth*x, height/2, fBgBoxSliceWidth, +fBgBoxHeight );
      fill( 1.0f, 1.0f, 1.0f, .09f * ( 1.0f - 1.0f/float(gnBgBoxGradientLevel)*float(x) ) * fAnimationRatio );
      rect( fBgBoxOffsetX + fBgBoxSliceWidth*x, height/2, fBgBoxSliceWidth, -fBgBoxHeight );
      
    }
    
    textFont(myFont3);
    textAlign(LEFT, CENTER);
    fill(1.0f, 1.0f, 1.0f, .2f);
    text(str(gnYearStart+y), fBgBoxOffsetX, height/2 + fBgBoxHeight * .95f);
    //fill(1.0f, 1.0f, 1.0f, .5f);
    //text(str(gnYearStart+y), fBgBoxOffsetX, height/2 - fBgBoxHeight * .95f);
    
  }
  
  
   // draw main title
    textFont(myFont);
    fill(1.0f, 0.0f, 0.0f, 0.1f+(0.9f/width)*mouseX);
    textAlign(LEFT,CENTER);
    text("NYTimes: South Korea | North Korea 2005-2011", 20, 20);

   // draw main title
    textFont(myFont);
    textAlign(LEFT,CENTER);
    fill(0.0f, 0.0f, 1.0f, 0.1f+(0.9f/width)*(width-mouseX));
    text("SPL: South Korea | North Korea 2005-2011", 20, 40);
    
    // projec title
   textFont(myFont3);  
   fill(0.3f);
   textAlign(RIGHT, CENTER);
   text("Project 3: Correlation Data, MAT 259 Winter 2012", 1000, 730);
   text("by Yoon Chung Han", 1000, 745);
   

  // draw data
  for (int n = 0; n < nItems; n++ ) {

    float fX = gfHMargin + fWidth * n;
    float fY = height/2;
    float fHeightN_NY = -gNYTimesFreq[0][n]/float(gNYTimesFreqMax)*fHeight; // * fAnimationRatio;
    float fHeightS_NY = +gNYTimesFreq[1][n]/float(gNYTimesFreqMax)*fHeight; // * fAnimationRatio;
    float fHeightN_SPL = -gSPLFreq[0][n]/float(gSPLFreqMax)*fHeight; // * fAnimationRatio;
    float fHeightS_SPL = +gSPLFreq[1][n]/float(gSPLFreqMax)*fHeight; // * fAnimationRatio;
    
    float ftX = gfHMargin + fWidth * gnMouseEventBarX;
    float ftY = height/2;
    float fHeightEvent = .0f;
    float fHeightEventText = .0f;
    
    textFont(myFont2);
    textAlign(LEFT, CENTER);

    // south korea - NY Times
    noStroke();
    fill(0.0f, 0.0f, 1.0f, .1f + 1.f * (((float)gNYTimesFreq[1][n]/(float)gNYTimesFreqMax)/width) * mouseX);
    rect( fX, fY, fWidth, fHeightS_NY);
    
    // draw texts
    String strText1 = str(gNYTimesFreq[1][n]);
    text(strText1, fX, fHeightS_NY+height/2+10);
    
    // north korea - NY Times
    noStroke();
    fill(1.0f, 0.0f, 0.0f, .1f + 1.f * (((float)gNYTimesFreq[0][n]/(float)gNYTimesFreqMax)/width) * mouseX);
    rect( fX, fY, fWidth, fHeightN_NY );
    
    // draw texts
    String strText2 = str(gNYTimesFreq[0][n]);
    text(strText2, fX, fHeightN_NY+height/2-10 );
    
     // south korea - SPL
    noStroke();
    fill(RGB_R1, RGB_G1, RGB_B1, .1f + 1.f * (((float)gSPLFreq[1][n]/(float)gSPLFreqMax)/width) * (width-mouseX));
    rect( fX, fY, fWidth, fHeightS_SPL );
    
    // draw texts
    textFont(myFont2);
    String strText3 = str(gSPLFreq[1][n]);
    text(strText3, fX, fHeightS_SPL+height/2+10);

    // north korea - SPL
    noStroke();
    fill(RGB_R2, RGB_G2, RGB_B2, .1f + 1.f * (((float)gSPLFreq[0][n]/(float)gSPLFreqMax)/width) * (width-mouseX));
    rect( fX, fY, fWidth, fHeightN_SPL );
    
       // draw texts
    String strText4 = str(gSPLFreq[0][n]);
    text(strText4, fX, fHeightN_SPL+height/2-10 );
    
  }
    
  popMatrix();
  popStyle();
  
  
}

