// implemented by Joshua Dickinson, updated by Yoon Chung Han

import org.json.*;

String baseURL = "http://api.nytimes.com/svc/search/v1/article";
String apiKey = "2c4094f9012ef6f5c40ba2c6f74c9d78:7:65423204";
PFont myFont = createFont("Helvetica", 14);
int lengthOfRainbow = 100;
int rainbowOffset = 0;

void setup() {
smooth();
size(500,600);
background(0);
textFont(myFont);
textAlign(CENTER, CENTER);
String[] words = {"apple", "microsoft", "samsung", "nokia", "sony"};
colorMode(HSB, 360,100,100);

int barSize = 100;
float startY = 80.0;

String start = "20030101";
String end = "20080101";
fill(360,0,60);
text("New York Times articles including these terms from 2009 to 2011", width/2, 40);

for (int i = 0; i < words.length; i++) {
     int freq = getArticleKeywordCount( words[i], start, end);
     noFill();
     stroke(i*(lengthOfRainbow/words.length)+rainbowOffset, 30,100,90);  
     ellipse(width/2, startY + (barSize * i), sqrt(freq),sqrt(freq));
     println(freq);
     
     
     fill(i*(lengthOfRainbow/words.length)+rainbowOffset, 100,100,90);
     text(words[i], 100, startY + (barSize * i));
     text(freq, width-100, startY + (barSize * i));
     
     /*int howManyCurves = freq;
     for(int j = 0; j < howManyCurves; j += 1) {
        noFill();
        stroke(i*(lengthOfRainbow/words.length)+rainbowOffset, 100,100,30); 
        bezier(100, startY + (barSize * i),  random(width), startY + (barSize * i) - 40, random(width),  startY + (barSize * i) - 40, 
        width/2+round(random(sqrt(freq))), startY + (barSize * i)+ round(random(sqrt(freq))));
     }*/
  }
}

void draw() {
//no draw loop.
};

int getArticleKeywordCount(String word, String beginDate, String endDate) {
    String request = baseURL + "?query=" + word + "&begin_date=" + beginDate + "&end_date=" + endDate + "&api-key=" + apiKey;
    println(request);
    String result = join( loadStrings( request ), "");
    
    int total = 0;
    
    try {
    JSONObject nytData = new JSONObject(join(loadStrings(request), ""));
    JSONArray results = nytData.getJSONArray("results");
    total = nytData.getInt("total");
    println ("There were " + total + " occurences of the term " + word + " between " + beginDate + " and " + endDate);
    }
    catch (JSONException e) {
    println ("There was an error parsing the JSONObject.");
    };
    
    return(total);
};
